<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class FirebaseAuthService
{
    private $apiKey;
    private $projectId;
    private $authUrl;
    
    public function __construct()
    {
        $this->apiKey = 'AIzaSyDsA1JohORkg-EdXWTHlFEea8zCqfvig8w';
        $this->projectId = 'titan-drilling-1f8e9';
        $this->authUrl = 'https://identitytoolkit.googleapis.com/v1/accounts:signUp';
    }
    
    /**
     * Create a new user in Firebase Authentication
     */
    public function createUser($email, $password, $displayName = null)
    {
        try {
            $payload = [
                'email' => $email,
                'password' => $password,
                'returnSecureToken' => true
            ];
            
            if ($displayName) {
                $payload['displayName'] = $displayName;
            }
            
            Log::info('Creating Firebase Auth user', [
                'email' => $email,
                'displayName' => $displayName
            ]);
            
            $response = Http::post($this->authUrl . '?key=' . $this->apiKey, $payload);
            
            if ($response->successful()) {
                $data = $response->json();
                
                Log::info('Firebase Auth user created successfully', [
                    'uid' => $data['localId'],
                    'email' => $data['email']
                ]);
                
                return [
                    'success' => true,
                    'uid' => $data['localId'],
                    'email' => $data['email'],
                    'idToken' => $data['idToken'],
                    'refreshToken' => $data['refreshToken']
                ];
            } else {
                $error = $response->json();
                Log::error('Failed to create Firebase Auth user', [
                    'error' => $error,
                    'status' => $response->status()
                ]);
                
                return [
                    'success' => false,
                    'message' => $error['error']['message'] ?? 'Failed to create user',
                    'code' => $error['error']['code'] ?? 'unknown'
                ];
            }
            
        } catch (\Exception $e) {
            Log::error('Exception in Firebase Auth user creation', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return [
                'success' => false,
                'message' => 'Exception occurred: ' . $e->getMessage()
            ];
        }
    }
    
    /**
     * Update user profile in Firebase Authentication
     */
    public function updateUserProfile($idToken, $displayName = null, $photoUrl = null)
    {
        try {
            $payload = [
                'idToken' => $idToken,
                'returnSecureToken' => true
            ];
            
            if ($displayName) {
                $payload['displayName'] = $displayName;
            }
            
            if ($photoUrl) {
                $payload['photoUrl'] = $photoUrl;
            }
            
            $response = Http::post('https://identitytoolkit.googleapis.com/v1/accounts:update?key=' . $this->apiKey, $payload);
            
            if ($response->successful()) {
                $data = $response->json();
                
                Log::info('Firebase Auth user profile updated successfully', [
                    'uid' => $data['localId']
                ]);
                
                return [
                    'success' => true,
                    'uid' => $data['localId'],
                    'data' => $data
                ];
            } else {
                $error = $response->json();
                Log::error('Failed to update Firebase Auth user profile', [
                    'error' => $error,
                    'status' => $response->status()
                ]);
                
                return [
                    'success' => false,
                    'message' => $error['error']['message'] ?? 'Failed to update user profile'
                ];
            }
            
        } catch (\Exception $e) {
            Log::error('Exception in Firebase Auth profile update', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return [
                'success' => false,
                'message' => 'Exception occurred: ' . $e->getMessage()
            ];
        }
    }
    
    /**
     * Delete user from Firebase Authentication
     */
    public function deleteUser($idToken)
    {
        try {
            $payload = [
                'idToken' => $idToken
            ];
            
            $response = Http::post('https://identitytoolkit.googleapis.com/v1/accounts:delete?key=' . $this->apiKey, $payload);
            
            if ($response->successful()) {
                Log::info('Firebase Auth user deleted successfully');
                
                return [
                    'success' => true,
                    'message' => 'User deleted successfully'
                ];
            } else {
                $error = $response->json();
                Log::error('Failed to delete Firebase Auth user', [
                    'error' => $error,
                    'status' => $response->status()
                ]);
                
                return [
                    'success' => false,
                    'message' => $error['error']['message'] ?? 'Failed to delete user'
                ];
            }
            
        } catch (\Exception $e) {
            Log::error('Exception in Firebase Auth user deletion', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return [
                'success' => false,
                'message' => 'Exception occurred: ' . $e->getMessage()
            ];
        }
    }
}
