<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;

class IncidentController extends Controller
{
    /**
     * Simulate incident report processing (NO ACTUAL SAVING)
     */
    public function store(Request $request): JsonResponse
    {
        try {
            // Log the incoming request for debugging
            Log::info('Incident report request received (SIMULATION ONLY)', [
                'request_data' => $request->all(),
                'incident_number' => $request->input('incidentNumber'),
                'note' => 'This is a simulation - no actual saving occurs'
            ]);

            // Simulate processing delay
            sleep(2);

            // Generate mock response data
            $incidentNumber = $request->input('incidentNumber', 'SIM-' . time());
            $reportId = time() . '_' . uniqid();
            
            return response()->json([
                'success' => true,
                'message' => 'Incident report processed successfully (SIMULATION)',
                'incidentNumber' => $incidentNumber,
                'reportId' => $reportId,
                'timestamp' => time(),
                'simulation' => true,
                'note' => 'This is a simulation - no data was actually saved'
            ]);

        } catch (\Exception $e) {
            Log::error('Error in incident report simulation: ' . $e->getMessage());

            return response()->json([
                'success' => false,
                'message' => 'An error occurred during simulation. Please try again.',
                'error_details' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * View incident report (SIMULATION ONLY)
     */
    public function view($id)
    {
        try {
            return response()->json([
                'message' => 'PDF viewing simulation - no actual PDF generated',
                'incidentId' => $id,
                'simulation' => true
            ]);
        } catch (\Exception $e) {
            Log::error('Error in incident report view simulation: ' . $e->getMessage());
            abort(500, 'Error in simulation');
        }
    }
}