// import React, { useState, useEffect, useCallback, useRef } from 'react';
// import {
//   View,
//   Text,
//   StyleSheet,
//   TouchableOpacity,
//   Image,
//   ScrollView,
//   Modal,
//   ActivityIndicator,
//   Animated,
//   Dimensions,
// } from 'react-native';
// import LinearGradient from 'react-native-linear-gradient';
// import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
// import { useNavigation, useRoute } from '@react-navigation/native';
// import AsyncStorage from '@react-native-async-storage/async-storage';
// import auth from '@react-native-firebase/auth';
// import database from '@react-native-firebase/database';
// import NetInfo from '@react-native-community/netinfo';
// import Toast from 'react-native-toast-message';
// import debounce from 'lodash.debounce';

// // SyncModal Component
// const SyncModal = ({ visible, onClose }) => {
//   const rotateAnim = useRef(new Animated.Value(0)).current;

//   const rotateInterpolate = rotateAnim.interpolate({
//     inputRange: [0, 1],
//     outputRange: ['0deg', '360deg'],
//   });

//   useEffect(() => {
//     if (visible) {
//       Animated.loop(
//         Animated.timing(rotateAnim, {
//           toValue: 1,
//           duration: 1000,
//           useNativeDriver: true,
//         })
//       ).start();
//     } else {
//       rotateAnim.setValue(0);
//     }
//   }, [visible]);

//   return (
//     <Modal visible={visible} transparent animationType="fade">
//       <View style={styles.syncModalContainer}>
//         <View style={styles.syncModalContent}>
//           <Text style={styles.syncModalText}>Please Wait</Text>
//           <View style={styles.syncIcondiv}>
//             <Animated.Image
//               source={require('../../../Images/adminlogin/sync.png')}
//               style={[
//                 styles.syncIcon,
//                 { transform: [{ rotate: rotateInterpolate }] },
//               ]}
//             />
//             <Text style={styles.syncModalTextadd}>Connecting to Firebase</Text>
//           </View>
//         </View>
//       </View>
//     </Modal>
//   );
// };

// // Helper function to clear login-related AsyncStorage data
// const clearLoginStorage = async () => {
//   try {
//     await AsyncStorage.removeItem('userEmail');
//     await AsyncStorage.removeItem('userPassword');
//     await AsyncStorage.removeItem('TeamMemberAdminuserUid');
//     await AsyncStorage.removeItem('teamMemberId');
//     await AsyncStorage.removeItem('teamMemberUserId');
//     await AsyncStorage.removeItem('Loginsuccess-01');
//     await AsyncStorage.removeItem('TeammemberLogin');
//     await AsyncStorage.removeItem('selectedCountry');
//     await AsyncStorage.removeItem('teamMemberData');
//     await AsyncStorage.removeItem('teamMemberAccessAreas');
//   } catch (error) {
//     console.error('Error clearing AsyncStorage:', error);
//   }
// };

// const Team_employment_Home = React.memo(() => {
//   const navigation = useNavigation();
//   const route = useRoute();
//   const [selectedCountry, setSelectedCountry] = useState('');
//   const [userId, setUserId] = useState(null);
//   const [loading, setLoading] = useState(false);
//   const [syncModalVisible, setSyncModalVisible] = useState(false);
//   const [dataLoaded, setDataLoaded] = useState(false);
//   const [accessAreas, setAccessAreas] = useState([]);
//   const [sessionStatus, setSessionStatus] = useState('Active'); // Default to Active since no session validation
//   const [role, setRole] = useState('');
//   const isMounted = useRef(true);

//   // Tab definitions with their corresponding access area permissions
//   const tabs = [
//     {
//       section: 'Master Data',
//       items: [
//         { name: 'Equipments', screen: 'Equipment_one', permission: 'Equipments', icon: require('../../../Images/adminhome/icosn/eq101.png') },
//         { name: 'Team/Employee', screen: 'Team_employment_Home', permission: 'Team management', icon: require('../../../Images/adminhome/icosn/eq102.png') },
//         { name: 'Documents', screen: 'Documenthome', permission: 'Documents', icon: require('../../../Images/adminhome/icosn/eq103.png') },
//       ],
//       kpiScreen: 'masterdatakpi',
//     },
//     {
//       section: 'Inspection and Compliances',
//       items: [
//         { name: 'Inspection Report', screen: 'Inspection_Report_Home', permission: 'Inspection Report', icon: require('../../../Images/adminhome/icosn/ins0101.png') },
//         { name: 'DVIR & Dot Inspection', screen: 'DviranddotInHome', permission: 'DVIR & DOT Inspection', icon: require('../../../Images/adminhome/icosn/eq103.png') },
//         { name: 'Check List', screen: 'Checklist_home', permission: 'Checklist', icon: require('../../../Images/adminhome/icosn/ins001.png') },
//       ],
//       kpiScreen: 'InspectionKpi',
//     },
//     {
//       section: 'Maintenance & Premium Services',
//       items: [
//         { name: 'Request Maintenance', screen: 'RequestmaintenanceHome', permission: 'Request Maintenance', icon: require('../../../Images/adminhome/icosn/mtn101.png') },
//         { name: 'Job Card', screen: 'WorkOrdertab', permission: 'Work Order', icon: require('../../../Images/adminhome/icosn/mtn102.png') },
//         { name: 'Service Schedule', screen: 'ServiceScheduleHome', permission: 'Service Schedule', icon: require('../../../Images/adminhome/icosn/mtn103.png') },
//       ],
//       kpiScreen: 'MaintenanceKpiHome',
//     },
//     {
//       section: 'Logbook',
//       items: [
//         { name: 'Fuel Log', screen: 'Fuel_Log_List', permission: 'Fuel Log', icon: require('../../../Images/adminhome/icosn/fuel1.png'), isFourth: true },
//         { name: 'Logbook', screen: 'LogbookList', permission: 'Daily Reporting', icon: require('../../../Images/adminhome/icosn/fuel2.png'), isFourth: true },
//       ],
//       kpiScreen: 'LogbookKpi',
//     },
//     {
//       section: 'HR',
//       items: [
//         { name: 'Application', screen: 'TeamHrApplyHome', permission: 'HR Application', icon: require('../../../Images/adminhome/icosn/hrform01.png'), isFourth: true },
//       ],
//       kpiScreen: null,
//     },
//   ];

//   // Check network status
//   const checkNetworkStatus = useCallback(async () => {
//     try {
//       const netInfo = await NetInfo.fetch();
//       return netInfo.isConnected;
//     } catch (error) {
//       console.error('Error checking network status:', error);
//       return false;
//     }
//   }, []);

//   // Show toast notification
//   const showToast = useCallback((type, text1, text2) => {
//     if (!isMounted.current) return;
//     Toast.show({
//       type,
//       text1,
//       text2,
//       position: 'bottom',
//       visibilityTime: 3000,
//       autoHide: true,
//     });
//   }, []);

//   // Retry mechanism for Firebase operations
//   const withRetry = useCallback(async (operation, maxAttempts = 3, delay = 1000) => {
//     for (let attempt = 1; attempt <= maxAttempts; attempt++) {
//       try {
//         return await operation();
//       } catch (error) {
//         if (attempt === maxAttempts) throw error;
//         console.log(`Attempt ${attempt} failed, retrying after ${delay}ms...`);
//         await new Promise((resolve) => setTimeout(resolve, delay));
//       }
//     }
//   }, []);

//   // Check Firebase connection by UID
//   const checkFirebaseConnection = useCallback(async (uid) => {
//     try {
//       setSyncModalVisible(true);
//       const userRef = database().ref(`/users/${uid}`);
//       await withRetry(() => userRef.once('value'), 2, 1000);
//       if (isMounted.current) {
//         showToast('success', 'Success', 'Connected successfully to Firebase');
//       }
//     } catch (error) {
//       console.error('Firebase connection error:', error);
//       if (!isMounted.current) return;
//       let errorMessage = 'Failed to connect to Firebase. Please try again.';
//       if (error.message.includes('timeout')) {
//         errorMessage = 'Firebase connection timed out. Using offline data.';
//       } else if (error.code === 'PERMISSION_DENIED') {
//         errorMessage = 'Permission denied. Please contact support.';
//       } else if (error.code === 'NETWORK_ERROR' || !(await checkNetworkStatus())) {
//         errorMessage = 'Offline mode. Data will sync when online.';
//       }
//       showToast('error', 'Error', errorMessage);
//     } finally {
//       if (isMounted.current) {
//         setSyncModalVisible(false);
//       }
//     }
//   }, [showToast, withRetry, checkNetworkStatus]);

//   // Load user data and access areas
//   useEffect(() => {
//     let authUnsubscribe;

//     const loadData = async () => {
//       setSyncModalVisible(true);
//       const timeoutId = setTimeout(() => {
//         if (isMounted.current && syncModalVisible) {
//           setSyncModalVisible(false);
//           if (!dataLoaded) {
//             showToast('error', 'Error', 'Data loading taking longer than expected. Please check your connection.');
//           }
//         }
//       }, 3000);

//       try {
//         // Check local credentials instead of session
//         const teamMemberUserId = await AsyncStorage.getItem('teamMemberUserId');
//         const adminUid = await AsyncStorage.getItem('TeamMemberAdminuserUid');
//         if (!teamMemberUserId || !adminUid) {
//           showToast('error', 'Session Error', 'No active user found. Please log in again.');
//           navigation.replace('TeamMemberLogin');
//           return;
//         }

//         authUnsubscribe = auth().onAuthStateChanged(async (user) => {
//           if (!isMounted.current) return;

//           const uid = user ? user.uid : null;
//           setUserId(uid);

//           if (uid && (await checkNetworkStatus())) {
//             await checkFirebaseConnection(uid);
//           }

//           try {
//             const teamMemberId = await AsyncStorage.getItem('teamMemberId');

//             // Load cached data first
//             const cachedData = await AsyncStorage.getItem('teamMemberData');
//             if (cachedData) {
//               const parsedData = JSON.parse(cachedData);
//               setRole(parsedData.role || 'N/A');
//               setSelectedCountry(parsedData.country || 'Not set');
//             }

//             if (adminUid && teamMemberId) {
//               // Fetch access areas and role
//               const teamMemberRef = database().ref(`/TeamMember/employ/${adminUid}/${teamMemberId}`);
//               const snapshot = await teamMemberRef.once('value');
//               const teamMemberData = snapshot.val();

//               if (teamMemberData) {
//                 if (teamMemberData.accessAreas) {
//                   setAccessAreas(teamMemberData.accessAreas);
//                   await AsyncStorage.setItem('teamMemberAccessAreas', JSON.stringify(teamMemberData.accessAreas));
//                 }
//                 if (teamMemberData.role) {
//                   setRole(teamMemberData.role);
//                 } else {
//                   showToast('warning', 'Warning', 'Role not found in database.');
//                   setRole('N/A');
//                 }
//               } else {
//                 const storedTeamMembers = await AsyncStorage.getItem('teamMembers');
//                 const storedAccessAreas = await AsyncStorage.getItem('teamMemberAccessAreas');
//                 if (storedTeamMembers) {
//                   const teamMembers = JSON.parse(storedTeamMembers);
//                   const currentMember = teamMembers.find(
//                     (member) => member.id === teamMemberId && member.adminUid === adminUid
//                   );
//                   if (currentMember) {
//                     if (currentMember.accessAreas) {
//                       setAccessAreas(currentMember.accessAreas);
//                     }
//                     if (currentMember.role) {
//                       setRole(currentMember.role);
//                     } else {
//                       setRole('N/A');
//                     }
//                   }
//                 } else if (storedAccessAreas) {
//                   setAccessAreas(JSON.parse(storedAccessAreas));
//                 }
//               }

//               // Fetch country from GlobalTeamMemberInformation
//               const globalRef = database().ref(`/GlobalTeamMemberInformation/${teamMemberId}`);
//               const globalSnapshot = await globalRef.once('value');
//               const globalData = globalSnapshot.val();
//               let countryValue = 'Not set';
//               if (globalData && globalData.country) {
//                 countryValue = Array.isArray(globalData.country)
//                   ? globalData.country.join(', ')
//                   : globalData.country;
//                 setSelectedCountry(countryValue);
//                 await AsyncStorage.setItem('selectedCountry', countryValue);
//               } else {
//                 const cachedCountry = await AsyncStorage.getItem('selectedCountry');
//                 if (cachedCountry) {
//                   setSelectedCountry(cachedCountry);
//                 } else {
//                   setSelectedCountry('Not set');
//                 }
//               }

//               // Cache role and country
//               await AsyncStorage.setItem('teamMemberData', JSON.stringify({
//                 role: teamMemberData?.role || 'N/A',
//                 country: countryValue,
//               }));
//             }

//             if (isMounted.current) {
//               setDataLoaded(true);
//             }
//           } catch (error) {
//             console.error('Error loading data:', error);
//             if (!isMounted.current) return;
//             setDataLoaded(true);
//             let errorMessage = 'Failed to load user data. Please try again.';
//             if (error.message.includes('timeout')) {
//               errorMessage = 'Data loading timed out. Using offline data.';
//             } else if (error.code === 'PERMISSION_DENIED') {
//               errorMessage = 'Permission denied. Please contact support.';
//             } else if (error.code === 'NETWORK_ERROR' || !(await checkNetworkStatus())) {
//               errorMessage = 'Offline mode. Data will sync when online.';
//               const cachedCountry = await AsyncStorage.getItem('selectedCountry');
//               if (cachedCountry) {
//                 setSelectedCountry(cachedCountry);
//               }
//               const cachedAccessAreas = await AsyncStorage.getItem('teamMemberAccessAreas');
//               if (cachedAccessAreas) {
//                 setAccessAreas(JSON.parse(cachedAccessAreas));
//               }
//               const cachedData = await AsyncStorage.getItem('teamMemberData');
//               if (cachedData) {
//                 const parsedData = JSON.parse(cachedData);
//                 setRole(parsedData.role || 'N/A');
//               }
//             }
//             showToast('error', 'Error', errorMessage);
//           }
//         });
//       } catch (error) {
//         console.error('Auth state listener error:', error);
//         if (isMounted.current) {
//           setDataLoaded(true);
//           showToast('error', 'Error', 'Failed to initialize authentication.');
//         }
//       } finally {
//         clearTimeout(timeoutId);
//         if (isMounted.current) {
//           setSyncModalVisible(false);
//         }
//       }
//     };

//     loadData();

//     const unsubscribeNetInfo = NetInfo.addEventListener((state) => {
//       if (!isMounted.current) return;
//       if (!state.isConnected && selectedCountry) {
//         showToast('info', 'Offline', 'You are offline. Changes will sync when online.');
//       }
//     });

//     return () => {
//       isMounted.current = false;
//       if (authUnsubscribe) authUnsubscribe();
//       unsubscribeNetInfo();
//       setLoading(false);
//       setSyncModalVisible(false);
//     };
//   }, [checkNetworkStatus, showToast, withRetry, checkFirebaseConnection]);

//   // Log navigation action
//   const logNavigationAction = useCallback(
//     async (action) => {
//       if (!userId) return;

//       try {
//         if (!(await checkNetworkStatus())) {
//           console.log('Offline: Navigation action not logged');
//           return;
//         }

//         const timestamp = new Date().toISOString();
//         const actionData = {
//           action,
//           timestamp,
//           selectedCountry: selectedCountry || 'None',
//           userId,
//         };

//         await withRetry(() =>
//           database()
//             .ref(`/navigationLogs/${userId}/${timestamp.replace(/[:.]/g, '-')}`)
//             .set(actionData)
//         );
//       } catch (error) {
//         console.error('Error logging navigation action:', error);
//         if (!isMounted.current) return;
//         showToast('error', 'Error', 'Failed to log navigation action.');
//       }
//     },
//     [userId, selectedCountry, showToast, checkNetworkStatus, withRetry]
//   );

//   const handlePress = useCallback(
//     (action, actionName) => {
//       if (!selectedCountry || selectedCountry === 'Not set') {
//         showToast('error', 'Error', 'Country not set. Please contact support.');
//         return;
//       }
//       if (actionName) {
//         logNavigationAction(actionName).then(() => action());
//       } else {
//         action();
//       }
//     },
//     [selectedCountry, logNavigationAction, showToast]
//   );

//   // Logout function
//   const handleLogout = async () => {
//     try {
//       await clearLoginStorage();
//       showToast('success', 'Logged Out', 'You have been logged out successfully.');
//       navigation.replace('TeamMemberLogin');
//     } catch (error) {
//       console.error('Error logging out:', error);
//       showToast('error', 'Logout Error', 'Failed to log out. Please try again.');
//     }
//   };

//   return (
//     <>
//       <ScrollView style={styles.scrollContainer}>
//         <View style={styles.container}>
//           {/* Session Status and Logout */}
//           <View style={styles.headerContainer}>
//             <Text style={styles.sessionStatusText}>Session Status: {sessionStatus}</Text>
//             <TouchableOpacity onPress={handleLogout}>
//               <Text style={styles.logoutText}>Logout</Text>
//             </TouchableOpacity>
//           </View>

//           {/* Country and Role Display Field */}
//           <View style={styles.countryContainer}>
//             <View style={styles.countryDisplay}>
//               <Text style={styles.countryLabel}>Country:</Text>
//               <Text style={styles.countryText}>
//                 {selectedCountry || 'Loading...'}
//               </Text>
//             </View>
//             <View style={styles.countryDisplay}>
//               <Text style={styles.countryLabel}>Role:</Text>
//               <Text style={styles.countryText}>
//                 {role || 'Loading...'}
//               </Text>
//             </View>
//           </View>

//           {/* SyncModal for Loading */}
//           <SyncModal
//             visible={syncModalVisible}
//             onClose={() => setSyncModalVisible(false)}
//           />

//           {/* Render Sections Dynamically */}
//           {tabs.map((section) => {
//             const allowedItems = section.items.filter((item) =>
//               accessAreas.includes(item.permission)
//             );

//             if (allowedItems.length === 0) return null;

//             return (
//               <View key={section.section} style={styles.sectionContainer}>
//                 <Text style={styles.heading}>{section.section}</Text>
//                 {(() => {
//                   const deviceWidth = Dimensions.get('window').width;
//                   const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
//                   return (
//                     <View style={styles.row}>
//                       {allowedItems.map((item) => (
//                         <TouchableOpacity
//                           key={item.name}
//                           style={styles.boxContainer}
//                           onPress={() =>
//                             handlePress(() => navigation.navigate(item.screen), item.name)
//                           }
//                           activeOpacity={0.8}
//                         >
//                           <View style={[styles.box, { width: boxSize, height: boxSize }]}>
//                             <Image
//                               source={item.icon}
//                               style={styles.icon}
//                               resizeMode="contain"
//                             />
//                           </View>
//                           <Text style={styles.boxText}>{item.name}</Text>
//                         </TouchableOpacity>
//                       ))}
//                       {/* Add empty placeholders for Logbook and HR sections if needed */}
//                       {(section.section === 'Logbook' || section.section === 'HR') &&
//                         allowedItems.length < 4 &&
//                         Array.from({ length: 4 - allowedItems.length }).map((_, idx) => (
//                           <View
//                             key={`placeholder-${idx}`}
//                             style={[styles.boxContainer, { width: boxSize }]}
//                           />
//                         ))}
//                     </View>
//                   );
//                 })()}
//                 {section.kpiScreen && (
//                   <View style={styles.buttonContainer}>
//                     <TouchableOpacity
//                       style={styles.gradientButton}
//                       onPress={() => handlePress(() => navigation.navigate(section.kpiScreen))}
//                     >
//                       <LinearGradient
//                         colors={['#3481BC', '#025383']}
//                         style={styles.gradientButtonContent}
//                       >
//                         <Text style={styles.buttonText}>View KPI</Text>
//                       </LinearGradient>
//                     </TouchableOpacity>
//                   </View>
//                 )}
//               </View>
//             );
//           })}

//           {/* Fifth Heading */}
//           <Text style={styles.heading}>Equipments</Text>
//           {/* Fifth Row of Boxes (Equipments) */}
//           {(() => {
//             const deviceWidth = Dimensions.get('window').width;
//             const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
//             const items = [
//               {
//                 icon: require('../../../Images/adminhome/icosn/hrform01.png'),
//                 label: 'Equipments',
//                 onPress: () => handlePress(() => navigation.navigate('TeamMemberEquipHome'))
//               },
//             ];
//             return (
//               <View style={{
//                 flexDirection: 'row',
//                 justifyContent: 'center',
//                 alignItems: 'flex-start',
//                 marginBottom: 18
//               }}>
//                 {items.map((item, idx) => (
//                   <TouchableOpacity
//                     key={item.label}
//                     style={{ alignItems: 'center', marginHorizontal: 8 }}
//                     onPress={item.onPress}
//                     activeOpacity={0.8}
//                   >
//                     <View style={{
//                       backgroundColor: '#035484',
//                       borderRadius: 12,
//                       width: boxSize,
//                       height: boxSize,
//                       justifyContent: 'center',
//                       alignItems: 'center',
//                       marginBottom: 8
//                     }}>
//                       <Image source={item.icon} style={{ width: 48, height: 48, resizeMode: 'contain' }} />
//                     </View>
//                     <Text style={{
//                       color: '#29486A',
//                       fontWeight: 'bold',
//                       fontSize: 13,
//                       textAlign: 'center',
//                       width: boxSize
//                     }}>{item.label}</Text>
//                   </TouchableOpacity>
//                 ))}
//               </View>
//             );
//           })()}

//           {/* Sixth Heading */}
//           <Text style={styles.heading}>HR</Text>
//           {/* Sixth Row of Boxes (HR) */}
//           {(() => {
//             const deviceWidth = Dimensions.get('window').width;
//             const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
//             const items = [
//               {
//                 icon: require('../../../Images/adminhome/icosn/hrform01.png'),
//                 label: 'Application',
//                 onPress: () => handlePress(() => navigation.navigate('TeamHrApplyHome'))
//               },
//             ];
//             return (
//               <View style={{
//                 flexDirection: 'row',
//                 justifyContent: 'center',
//                 alignItems: 'flex-start',
//                 marginBottom: 18
//               }}>
//                 {items.map((item, idx) => (
//                   <TouchableOpacity
//                     key={item.label}
//                     style={{ alignItems: 'center', marginHorizontal: 8 }}
//                     onPress={item.onPress}
//                     activeOpacity={0.8}
//                   >
//                     <View style={{
//                       backgroundColor: '#035484',
//                       borderRadius: 12,
//                       width: boxSize,
//                       height: boxSize,
//                       justifyContent: 'center',
//                       alignItems: 'center',
//                       marginBottom: 8
//                     }}>
//                       <Image source={item.icon} style={{ width: 48, height: 48, resizeMode: 'contain' }} />
//                     </View>
//                     <Text style={{
//                       color: '#29486A',
//                       fontWeight: 'bold',
//                       fontSize: 13,
//                       textAlign: 'center',
//                       width: boxSize
//                     }}>{item.label}</Text>
//                   </TouchableOpacity>
//                 ))}
//               </View>
//             );
//           })()}

//           {/* Seventh Heading */}
//           <Text style={styles.heading}>Inspections Report</Text>
//           {/* Seventh Row of Boxes (Inspections Report) */}
//           {(() => {
//             const deviceWidth = Dimensions.get('window').width;
//             const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
//             const items = [
//               {
//                 icon: require('../../../Images/adminhome/icosn/hrform01.png'),
//                 label: 'Inspection',
//                 onPress: () => handlePress(() => navigation.navigate('TeammemInsHome'))
//               },
//             ];
//             return (
//               <View style={{
//                 flexDirection: 'row',
//                 justifyContent: 'center',
//                 alignItems: 'flex-start',
//                 marginBottom: 18
//               }}>
//                 {items.map((item, idx) => (
//                   <TouchableOpacity
//                     key={item.label}
//                     style={{ alignItems: 'center', marginHorizontal: 8 }}
//                     onPress={item.onPress}
//                     activeOpacity={0.8}
//                   >
//                     <View style={{
//                       backgroundColor: '#035484',
//                       borderRadius: 12,
//                       width: boxSize,
//                       height: boxSize,
//                       justifyContent: 'center',
//                       alignItems: 'center',
//                       marginBottom: 8
//                     }}>
//                       <Image source={item.icon} style={{ width: 48, height: 48, resizeMode: 'contain' }} />
//                     </View>
//                     <Text style={{
//                       color: '#29486A',
//                       fontWeight: 'bold',
//                       fontSize: 13,
//                       textAlign: 'center',
//                       width: boxSize
//                     }}>{item.label}</Text>
//                   </TouchableOpacity>
//                 ))}
//               </View>
//             );
//           })()}
//         </View>
//       </ScrollView>
//       <Toast />
//     </>
//   );
// });

// const styles = StyleSheet.create({
//   scrollContainer: {
//     flex: 1,
//     backgroundColor: '#fff',
//   },
//   container: {
//     padding: 10,
//   },
//   headerContainer: {
//     flexDirection: 'row',
//     justifyContent: 'space-between',
//     alignItems: 'center',
//     paddingHorizontal: 20,
//     marginTop: 10,
//     marginBottom: 10,
//   },
//   sessionStatusText: {
//     fontSize: 16,
//     color: '#015185',
//     fontWeight: 'bold',
//   },
//   logoutText: {
//     fontSize: 16,
//     color: '#ff0000',
//     fontWeight: 'bold',
//   },
//   countryContainer: {
//     flexDirection: 'column',
//     justifyContent: 'flex-end',
//     alignItems: 'flex-end',
//     paddingHorizontal: 20,
//     marginBottom: 10,
//   },
//   countryDisplay: {
//     borderWidth: 2,
//     borderColor: '#035484',
//     paddingHorizontal: 7,
//     paddingVertical: 3,
//     minWidth: '46%',
//     backgroundColor: '#f5f5f5',
//     flexDirection: 'row',
//     alignItems: 'center',
//     shadowColor: '#000',
//     shadowOpacity: 0.08,
//     shadowRadius: 4,
//     shadowOffset: { width: 0, height: 2 },
//     elevation: 2,
//     marginBottom: 5,
//   },
//   countryLabel: {
//     color: '#222',
//     fontSize: 16,
//     fontWeight: 'bold',
//     marginRight: 5,
//   },
//   countryText: {
//     color: '#222',
//     fontSize: 16,
//     flex: 1,
//   },
//   sectionContainer: {
//     marginBottom: 18,
//     paddingHorizontal: 4,
//   },
//   heading: {
//     fontSize: 24,
//     fontWeight: 'bold',
//     textAlign: 'center',
//     marginBottom: 13,
//     color: '#015185',
//   },
//   row: {
//     flexDirection: 'row',
//     justifyContent: 'center',
//     alignItems: 'flex-start',
//     marginBottom: 18,
//   },
//   boxContainer: {
//     alignItems: 'center',
//     marginHorizontal: 8,
//   },
//   box: {
//     backgroundColor: '#035484',
//     borderRadius: 12,
//     justifyContent: 'center',
//     alignItems: 'center',
//     marginBottom: 8,
//   },
//   icon: {
//     width: 48,
//     height: 48,
//   },
//   boxText: {
//     color: '#29486A',
//     fontWeight: 'bold',
//     fontSize: 13,
//     textAlign: 'center',
//   },
//   buttonContainer: {
//     alignItems: 'center',
//     marginVertical: 15,
//   },
//   gradientButton: {
//     width: '40%',
//     borderRadius: 5,
//     overflow: 'hidden',
//   },
//   gradientButtonContent: {
//     flexDirection: 'row',
//     justifyContent: 'center',
//     alignItems: 'center',
//     height: 40,
//   },
//   buttonText: {
//     color: 'white',
//     fontSize: 16,
//     fontWeight: 'bold',
//     marginRight: 5,
//   },
//   syncModalContainer: {
//     flex: 1,
//     backgroundColor: 'rgba(0,0,0,0.5)',
//     justifyContent: 'center',
//     alignItems: 'center',
//   },
//   syncModalContent: {
//     width: '70%',
//     backgroundColor: 'white',
//     borderRadius: 10,
//     padding: 20,
//     alignItems: 'center',
//   },
//   syncModalText: {
//     fontSize: 18,
//     marginBottom: 10,
//     color: '#333',
//   },
//   syncIcon: {
//     width: 30,
//     height: 30,
//     marginRight: 10,
//   },
//   syncModalTextadd: {
//     fontSize: 14,
//     color: '#333',
//   },
//   syncIcondiv: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     justifyContent: 'center',
//   },
// });

// export default Team_employment_Home;
import React, { useState, useEffect, useCallback, useRef } from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Image,
  ScrollView,
  Modal,
  ActivityIndicator,
  Animated,
  Dimensions,
} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import { useNavigation, useRoute } from '@react-navigation/native';
import AsyncStorage from '@react-native-async-storage/async-storage';
import auth from '@react-native-firebase/auth';
import database from '@react-native-firebase/database';
import NetInfo from '@react-native-community/netinfo';
import Toast from 'react-native-toast-message';
import debounce from 'lodash.debounce';

// SyncModal Component
const SyncModal = ({ visible, onClose }) => {
  const rotateAnim = useRef(new Animated.Value(0)).current;

  const rotateInterpolate = rotateAnim.interpolate({
    inputRange: [0, 1],
    outputRange: ['0deg', '360deg'],
  });

  useEffect(() => {
    if (visible) {
      Animated.loop(
        Animated.timing(rotateAnim, {
          toValue: 1,
          duration: 1000,
          useNativeDriver: true,
        })
      ).start();
    } else {
      rotateAnim.setValue(0);
    }
  }, [visible]);

  return (
    <Modal visible={visible} transparent animationType="fade">
      <View style={styles.syncModalContainer}>
        <View style={styles.syncModalContent}>
          <Text style={styles.syncModalText}>Please Wait</Text>
          <View style={styles.syncIcondiv}>
            <Animated.Image
              source={require('../../../Images/adminlogin/sync.png')}
              style={[
                styles.syncIcon,
                { transform: [{ rotate: rotateInterpolate }] },
              ]}
            />
            <Text style={styles.syncModalTextadd}>Connecting to Firebase</Text>
          </View>
        </View>
      </View>
    </Modal>
  );
};

// Helper function to clear login-related AsyncStorage data
const clearLoginStorage = async () => {
  try {
    await AsyncStorage.removeItem('userEmail');
    await AsyncStorage.removeItem('userPassword');
    await AsyncStorage.removeItem('TeamMemberAdminuserUid');
    await AsyncStorage.removeItem('teamMemberId');
    await AsyncStorage.removeItem('teamMemberUserId');
    await AsyncStorage.removeItem('Loginsuccess-01');
    await AsyncStorage.removeItem('TeammemberLogin');
    await AsyncStorage.removeItem('selectedCountry');
    await AsyncStorage.removeItem('teamMemberData');
    await AsyncStorage.removeItem('teamMemberAccessAreas');
  } catch (error) {
    console.error('Error clearing AsyncStorage:', error);
  }
};

const Team_employment_Home = React.memo(() => {
  const navigation = useNavigation();
  const route = useRoute();
  const [selectedCountry, setSelectedCountry] = useState('');
  const [userId, setUserId] = useState(null);
  const [loading, setLoading] = useState(false);
  const [syncModalVisible, setSyncModalVisible] = useState(false);
  const [dataLoaded, setDataLoaded] = useState(false);
  const [accessAreas, setAccessAreas] = useState([]);
  const [sessionStatus, setSessionStatus] = useState('Active'); // Default to Active since no session validation
  const [role, setRole] = useState('');
  const isMounted = useRef(true);

  // Tab definitions with their corresponding access area permissions
  const tabs = [
    {
      section: 'Master Data',
      items: [
        { name: 'Equipments', screen: 'Equipment_one', permission: 'Equipments', icon: require('../../../Images/adminhome/icosn/eq101.png') },
        { name: 'Team/Employee', screen: 'Team_employment_Home', permission: 'Team management', icon: require('../../../Images/adminhome/icosn/eq102.png') },
        { name: 'Documents', screen: 'Documenthome', permission: 'Documents', icon: require('../../../Images/adminhome/icosn/eq103.png') },
      ],
      kpiScreen: 'masterdatakpi',
    },
    {
      section: 'Inspection and Compliances',
      items: [
        { name: 'Inspection Report', screen: 'Inspection_Report_Home', permission: 'Inspection Report', icon: require('../../../Images/adminhome/icosn/ins0101.png') },
        { name: 'DVIR & Dot Inspection', screen: 'DviranddotInHome', permission: 'DVIR & DOT Inspection', icon: require('../../../Images/adminhome/icosn/eq103.png') },
        { name: 'Check List', screen: 'Checklist_home', permission: 'Checklist', icon: require('../../../Images/adminhome/icosn/ins001.png') },
      ],
      kpiScreen: 'InspectionKpi',
    },
    {
      section: 'Maintenance & Premium Services',
      items: [
        { name: 'Request Maintenance', screen: 'RequestmaintenanceHome', permission: 'Request Maintenance', icon: require('../../../Images/adminhome/icosn/mtn101.png') },
        { name: 'Job Card', screen: 'WorkOrdertab', permission: 'Work Order', icon: require('../../../Images/adminhome/icosn/mtn102.png') },
        { name: 'Service Schedule', screen: 'ServiceScheduleHome', permission: 'Service Schedule', icon: require('../../../Images/adminhome/icosn/mtn103.png') },
      ],
      kpiScreen: 'MaintenanceKpiHome',
    },
    {
      section: 'Logbook',
      items: [
        { name: 'Fuel Log', screen: 'Fuel_Log_List', permission: 'Fuel Log', icon: require('../../../Images/adminhome/icosn/fuel1.png'), isFourth: true },
        { name: 'Logbook', screen: 'LogbookList', permission: 'Daily Reporting', icon: require('../../../Images/adminhome/icosn/fuel2.png'), isFourth: true },
      ],
      kpiScreen: 'LogbookKPI',
    },
    {
      section: 'HR',
      items: [
        { name: 'Application', screen: 'TeamHrApplyHome', permission: 'HR Application', icon: require('../../../Images/adminhome/icosn/hrform01.png'), isFourth: true },
      ],
      kpiScreen: null,
    },
  ];

  // Check network status
  const checkNetworkStatus = useCallback(async () => {
    try {
      const netInfo = await NetInfo.fetch();
      return netInfo.isConnected;
    } catch (error) {
      console.error('Error checking network status:', error);
      return false;
    }
  }, []);

  // Show toast notification
  const showToast = useCallback((type, text1, text2) => {
    if (!isMounted.current) return;
    Toast.show({
      type,
      text1,
      text2,
      position: 'bottom',
      visibilityTime: 3000,
      autoHide: true,
    });
  }, []);

  // Retry mechanism for Firebase operations
  const withRetry = useCallback(async (operation, maxAttempts = 3, delay = 1000) => {
    for (let attempt = 1; attempt <= maxAttempts; attempt++) {
      try {
        return await operation();
      } catch (error) {
        if (attempt === maxAttempts) throw error;
        console.log(`Attempt ${attempt} failed, retrying after ${delay}ms...`);
        await new Promise((resolve) => setTimeout(resolve, delay));
      }
    }
  }, []);

  // Check Firebase connection by UID
  const checkFirebaseConnection = useCallback(async (uid) => {
    try {
      setSyncModalVisible(true);
      const userRef = database().ref(`/users/${uid}`);
      await withRetry(() => userRef.once('value'), 2, 1000);
      if (isMounted.current) {
        showToast('success', 'Success', 'Connected successfully to Firebase');
      }
    } catch (error) {
      console.error('Firebase connection error:', error);
      if (!isMounted.current) return;
      let errorMessage = 'Failed to connect to Firebase. Please try again.';
      if (error.message.includes('timeout')) {
        errorMessage = 'Firebase connection timed out. Using offline data.';
      } else if (error.code === 'PERMISSION_DENIED') {
        errorMessage = 'Permission denied. Please contact support.';
      } else if (error.code === 'NETWORK_ERROR' || !(await checkNetworkStatus())) {
        errorMessage = 'Offline mode. Data will sync when online.';
      }
      showToast('error', 'Error', errorMessage);
    } finally {
      if (isMounted.current) {
        setSyncModalVisible(false);
      }
    }
  }, [showToast, withRetry, checkNetworkStatus]);

  // Load user data and access areas
  useEffect(() => {
    let authUnsubscribe;

    const loadData = async () => {
      setSyncModalVisible(true);
      const timeoutId = setTimeout(() => {
        if (isMounted.current && syncModalVisible) {
          setSyncModalVisible(false);
          if (!dataLoaded) {
            showToast('error', 'Error', 'Data loading taking longer than expected. Please check your connection.');
          }
        }
      }, 3000);

      try {
        // Check local credentials instead of session
        const teamMemberUserId = await AsyncStorage.getItem('teamMemberUserId');
        const adminUid = await AsyncStorage.getItem('TeamMemberAdminuserUid');
        if (!teamMemberUserId || !adminUid) {
          showToast('error', 'Session Error', 'No active user found. Please log in again.');
          navigation.replace('TeamMemberLogin');
          return;
        }

        authUnsubscribe = auth().onAuthStateChanged(async (user) => {
          if (!isMounted.current) return;

          const uid = user ? user.uid : null;
          setUserId(uid);

          if (uid && (await checkNetworkStatus())) {
            await checkFirebaseConnection(uid);
          }

          try {
            const teamMemberId = await AsyncStorage.getItem('teamMemberId');

            // Load cached data first
            const cachedData = await AsyncStorage.getItem('teamMemberData');
            if (cachedData) {
              const parsedData = JSON.parse(cachedData);
              setRole(parsedData.role || 'N/A');
              setSelectedCountry(parsedData.country || 'Not set');
            }

            if (adminUid && teamMemberId) {
              // Fetch access areas and role
              const teamMemberRef = database().ref(`/TeamMember/employ/${adminUid}/${teamMemberId}`);
              const snapshot = await teamMemberRef.once('value');
              const teamMemberData = snapshot.val();

              if (teamMemberData) {
                if (teamMemberData.accessAreas) {
                  setAccessAreas(teamMemberData.accessAreas);
                  await AsyncStorage.setItem('teamMemberAccessAreas', JSON.stringify(teamMemberData.accessAreas));
                }
                if (teamMemberData.role) {
                  setRole(teamMemberData.role);
                } else {
                  showToast('warning', 'Warning', 'Role not found in database.');
                  setRole('N/A');
                }
              } else {
                const storedTeamMembers = await AsyncStorage.getItem('teamMembers');
                const storedAccessAreas = await AsyncStorage.getItem('teamMemberAccessAreas');
                if (storedTeamMembers) {
                  const teamMembers = JSON.parse(storedTeamMembers);
                  const currentMember = teamMembers.find(
                    (member) => member.id === teamMemberId && member.adminUid === adminUid
                  );
                  if (currentMember) {
                    if (currentMember.accessAreas) {
                      setAccessAreas(currentMember.accessAreas);
                    }
                    if (currentMember.role) {
                      setRole(currentMember.role);
                    } else {
                      setRole('N/A');
                    }
                  }
                } else if (storedAccessAreas) {
                  setAccessAreas(JSON.parse(storedAccessAreas));
                }
              }

              // Fetch country from GlobalTeamMemberInformation
              const globalRef = database().ref(`/GlobalTeamMemberInformation/${teamMemberId}`);
              const globalSnapshot = await globalRef.once('value');
              const globalData = globalSnapshot.val();
              let countryValue = 'Not set';
              if (globalData && globalData.country) {
                countryValue = Array.isArray(globalData.country)
                  ? globalData.country.join(', ')
                  : globalData.country;
                setSelectedCountry(countryValue);
                await AsyncStorage.setItem('selectedCountry', countryValue);
              } else {
                const cachedCountry = await AsyncStorage.getItem('selectedCountry');
                if (cachedCountry) {
                  setSelectedCountry(cachedCountry);
                } else {
                  setSelectedCountry('Not set');
                }
              }

              // Cache role and country
              await AsyncStorage.setItem('teamMemberData', JSON.stringify({
                role: teamMemberData?.role || 'N/A',
                country: countryValue,
              }));
            }

            if (isMounted.current) {
              setDataLoaded(true);
            }
          } catch (error) {
            console.error('Error loading data:', error);
            if (!isMounted.current) return;
            setDataLoaded(true);
            let errorMessage = 'Failed to load user data. Please try again.';
            if (error.message.includes('timeout')) {
              errorMessage = 'Data loading timed out. Using offline data.';
            } else if (error.code === 'PERMISSION_DENIED') {
              errorMessage = 'Permission denied. Please contact support.';
            } else if (error.code === 'NETWORK_ERROR' || !(await checkNetworkStatus())) {
              errorMessage = 'Offline mode. Data will sync when online.';
              const cachedCountry = await AsyncStorage.getItem('selectedCountry');
              if (cachedCountry) {
                setSelectedCountry(cachedCountry);
              }
              const cachedAccessAreas = await AsyncStorage.getItem('teamMemberAccessAreas');
              if (cachedAccessAreas) {
                setAccessAreas(JSON.parse(cachedAccessAreas));
              }
              const cachedData = await AsyncStorage.getItem('teamMemberData');
              if (cachedData) {
                const parsedData = JSON.parse(cachedData);
                setRole(parsedData.role || 'N/A');
              }
            }
            showToast('error', 'Error', errorMessage);
          }
        });
      } catch (error) {
        console.error('Auth state listener error:', error);
        if (isMounted.current) {
          setDataLoaded(true);
          showToast('error', 'Error', 'Failed to initialize authentication.');
        }
      } finally {
        clearTimeout(timeoutId);
        if (isMounted.current) {
          setSyncModalVisible(false);
        }
      }
    };

    loadData();

    const unsubscribeNetInfo = NetInfo.addEventListener((state) => {
      if (!isMounted.current) return;
      if (!state.isConnected && selectedCountry) {
        showToast('info', 'Offline', 'You are offline. Changes will sync when online.');
      }
    });

    return () => {
      isMounted.current = false;
      if (authUnsubscribe) authUnsubscribe();
      unsubscribeNetInfo();
      setLoading(false);
      setSyncModalVisible(false);
    };
  }, [checkNetworkStatus, showToast, withRetry, checkFirebaseConnection]);

  // Log navigation action
  const logNavigationAction = useCallback(
    async (action) => {
      if (!userId) return;

      try {
        if (!(await checkNetworkStatus())) {
          console.log('Offline: Navigation action not logged');
          return;
        }

        const timestamp = new Date().toISOString();
        const actionData = {
          action,
          timestamp,
          selectedCountry: selectedCountry || 'None',
          userId,
        };

        await withRetry(() =>
          database()
            .ref(`/navigationLogs/${userId}/${timestamp.replace(/[:.]/g, '-')}`)
            .set(actionData)
        );
      } catch (error) {
        console.error('Error logging navigation action:', error);
        if (!isMounted.current) return;
        showToast('error', 'Error', 'Failed to log navigation action.');
      }
    },
    [userId, selectedCountry, showToast, checkNetworkStatus, withRetry]
  );

  const handlePress = useCallback(
    (action, actionName) => {
      if (!selectedCountry || selectedCountry === 'Not set') {
        showToast('error', 'Error', 'Country not set. Please contact support.');
        return;
      }
      if (actionName) {
        logNavigationAction(actionName).then(() => action());
      } else {
        action();
      }
    },
    [selectedCountry, logNavigationAction, showToast]
  );

  // Logout function
  const handleLogout = async () => {
    try {
      await clearLoginStorage();
      showToast('success', 'Logged Out', 'You have been logged out successfully.');
      navigation.replace('TeamMemberLogin');
    } catch (error) {
      console.error('Error logging out:', error);
      showToast('error', 'Logout Error', 'Failed to log out. Please try again.');
    }
  };

  return (
    <>
      <ScrollView style={styles.scrollContainer}>
        <View style={styles.container}>
          {/* Session Status and Logout */}
          <View style={styles.headerContainer}>
            <Text style={styles.sessionStatusText}>Session Status: {sessionStatus}</Text>
            <TouchableOpacity onPress={handleLogout}>
              <Text style={styles.logoutText}>Logout</Text>
            </TouchableOpacity>
          </View>

          {/* Country and Role Display Field */}
          <View style={styles.countryContainer}>
            <View style={styles.countryDisplay}>
              <Text style={styles.countryLabel}>Country:</Text>
              <Text style={styles.countryText}>
                {selectedCountry || 'Loading...'}
              </Text>
            </View>
            <View style={styles.countryDisplay}>
              <Text style={styles.countryLabel}>Role:</Text>
              <Text style={styles.countryText}>
                {role || 'Loading...'}
              </Text>
            </View>
          </View>

          {/* SyncModal for Loading */}
          <SyncModal
            visible={syncModalVisible}
            onClose={() => setSyncModalVisible(false)}
          />

          {/* Render Sections Dynamically */}
          {tabs.map((section) => {
            const allowedItems = section.items.filter((item) =>
              accessAreas.includes(item.permission)
            );

            if (allowedItems.length === 0) return null;

            return (
              <View key={section.section} style={styles.sectionContainer}>
                <Text style={styles.heading}>{section.section}</Text>
                {(() => {
                  const deviceWidth = Dimensions.get('window').width;
                  const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
                  return (
                    <View style={styles.row}>
                      {allowedItems.map((item) => (
                        <TouchableOpacity
                          key={item.name}
                          style={styles.boxContainer}
                          onPress={() =>
                            handlePress(() => navigation.navigate(item.screen), item.name)
                          }
                          activeOpacity={0.8}
                        >
                          <View style={[styles.box, { width: boxSize, height: boxSize }]}>
                            <Image
                              source={item.icon}
                              style={styles.icon}
                              resizeMode="contain"
                            />
                          </View>
                          <Text style={styles.boxText}>{item.name}</Text>
                        </TouchableOpacity>
                      ))}
                      {/* Add empty placeholders for Logbook and HR sections if needed */}
                      {(section.section === 'Logbook' || section.section === 'HR') &&
                        allowedItems.length < 4 &&
                        Array.from({ length: 4 - allowedItems.length }).map((_, idx) => (
                          <View
                            key={`placeholder-${idx}`}
                            style={[styles.boxContainer, { width: boxSize }]}
                          />
                        ))}
                    </View>
                  );
                })()}
                {section.kpiScreen && (
                  <View style={styles.buttonContainer}>
                    <TouchableOpacity
                      style={styles.gradientButton}
                      onPress={() => handlePress(() => navigation.navigate(section.kpiScreen))}
                    >
                      <LinearGradient
                        colors={['#3481BC', '#025383']}
                        style={styles.gradientButtonContent}
                      >
                        <Text style={styles.buttonText}>View KPI</Text>
                      </LinearGradient>
                    </TouchableOpacity>
                  </View>
                )}
              </View>
            );
          })}

          {/* Fifth Heading */}
          <Text style={styles.heading}>Equipments</Text>
          {/* Fifth Row of Boxes (Equipments) */}
          {(() => {
            const deviceWidth = Dimensions.get('window').width;
            const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
            const items = [
              {
                icon: require('../../../Images/adminhome/icosn/hrform01.png'),
                label: 'Equipments',
                onPress: () => handlePress(() => navigation.navigate('TeamMemberEquipHome'))
              },
            ];
            return (
              <View style={{
                flexDirection: 'row',
                justifyContent: 'center',
                alignItems: 'flex-start',
                marginBottom: 18
              }}>
                {items.map((item, idx) => (
                  <TouchableOpacity
                    key={item.label}
                    style={{ alignItems: 'center', marginHorizontal: 8 }}
                    onPress={item.onPress}
                    activeOpacity={0.8}
                  >
                    <View style={{
                      backgroundColor: '#035484',
                      borderRadius: 12,
                      width: boxSize,
                      height: boxSize,
                      justifyContent: 'center',
                      alignItems: 'center',
                      marginBottom: 8
                    }}>
                      <Image source={item.icon} style={{ width: 48, height: 48, resizeMode: 'contain' }} />
                    </View>
                    <Text style={{
                      color: '#29486A',
                      fontWeight: 'bold',
                      fontSize: 13,
                      textAlign: 'center',
                      width: boxSize
                    }}>{item.label}</Text>
                  </TouchableOpacity>
                ))}
              </View>
            );
          })()}

          {/* Sixth Heading */}
          <Text style={styles.heading}>HR</Text>
          {/* Sixth Row of Boxes (HR) */}
          {(() => {
            const deviceWidth = Dimensions.get('window').width;
            const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
            const items = [
              {
                icon: require('../../../Images/adminhome/icosn/hrform01.png'),
                label: 'Application',
                onPress: () => handlePress(() => navigation.navigate('TeamHrApplyHome'))
              },
            ];
            return (
              <View style={{
                flexDirection: 'row',
                justifyContent: 'center',
                alignItems: 'flex-start',
                marginBottom: 18
              }}>
                {items.map((item, idx) => (
                  <TouchableOpacity
                    key={item.label}
                    style={{ alignItems: 'center', marginHorizontal: 8 }}
                    onPress={item.onPress}
                    activeOpacity={0.8}
                  >
                    <View style={{
                      backgroundColor: '#035484',
                      borderRadius: 12,
                      width: boxSize,
                      height: boxSize,
                      justifyContent: 'center',
                      alignItems: 'center',
                      marginBottom: 8
                    }}>
                      <Image source={item.icon} style={{ width: 48, height: 48, resizeMode: 'contain' }} />
                    </View>
                    <Text style={{
                      color: '#29486A',
                      fontWeight: 'bold',
                      fontSize: 13,
                      textAlign: 'center',
                      width: boxSize
                    }}>{item.label}</Text>
                  </TouchableOpacity>
                ))}
              </View>
            );
          })()}

          {/* Seventh Heading */}
          <Text style={styles.heading}>Inspections Report</Text>
          {/* Seventh Row of Boxes (Inspections Report) */}
          {(() => {
            const deviceWidth = Dimensions.get('window').width;
            const boxSize = Math.floor((deviceWidth - 5 * 16) / 4);
            const items = [
              {
                icon: require('../../../Images/adminhome/icosn/hrform01.png'),
                label: 'Inspection',
                onPress: () => handlePress(() => navigation.navigate('TeammemInsHome'))
              },
            ];
            return (
              <View style={{
                flexDirection: 'row',
                justifyContent: 'center',
                alignItems: 'flex-start',
                marginBottom: 18
              }}>
                {items.map((item, idx) => (
                  <TouchableOpacity
                    key={item.label}
                    style={{ alignItems: 'center', marginHorizontal: 8 }}
                    onPress={item.onPress}
                    activeOpacity={0.8}
                  >
                    <View style={{
                      backgroundColor: '#035484',
                      borderRadius: 12,
                      width: boxSize,
                      height: boxSize,
                      justifyContent: 'center',
                      alignItems: 'center',
                      marginBottom: 8
                    }}>
                      <Image source={item.icon} style={{ width: 48, height: 48, resizeMode: 'contain' }} />
                    </View>
                    <Text style={{
                      color: '#29486A',
                      fontWeight: 'bold',
                      fontSize: 13,
                      textAlign: 'center',
                      width: boxSize
                    }}>{item.label}</Text>
                  </TouchableOpacity>
                ))}
              </View>
            );
          })()}
        </View>
      </ScrollView>
      <Toast />
    </>
  );
});

const styles = StyleSheet.create({
  scrollContainer: {
    flex: 1,
    backgroundColor: '#fff',
  },
  container: {
    padding: 10,
  },
  headerContainer: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    paddingHorizontal: 20,
    marginTop: 10,
    marginBottom: 10,
  },
  sessionStatusText: {
    fontSize: 16,
    color: '#015185',
    fontWeight: 'bold',
  },
  logoutText: {
    fontSize: 16,
    color: '#ff0000',
    fontWeight: 'bold',
  },
  countryContainer: {
    flexDirection: 'column',
    justifyContent: 'flex-end',
    alignItems: 'flex-end',
    paddingHorizontal: 20,
    marginBottom: 10,
  },
  countryDisplay: {
    borderWidth: 2,
    borderColor: '#035484',
    paddingHorizontal: 7,
    paddingVertical: 3,
    minWidth: '46%',
    backgroundColor: '#f5f5f5',
    flexDirection: 'row',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOpacity: 0.08,
    shadowRadius: 4,
    shadowOffset: { width: 0, height: 2 },
    elevation: 2,
    marginBottom: 5,
  },
  countryLabel: {
    color: '#222',
    fontSize: 16,
    fontWeight: 'bold',
    marginRight: 5,
  },
  countryText: {
    color: '#222',
    fontSize: 16,
    flex: 1,
  },
  sectionContainer: {
    marginBottom: 18,
    paddingHorizontal: 4,
  },
  heading: {
    fontSize: 24,
    fontWeight: 'bold',
    textAlign: 'center',
    marginBottom: 13,
    color: '#015185',
  },
  row: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'flex-start',
    marginBottom: 18,
  },
  boxContainer: {
    alignItems: 'center',
    marginHorizontal: 8,
  },
  box: {
    backgroundColor: '#035484',
    borderRadius: 12,
    justifyContent: 'center',
    alignItems: 'center',
    marginBottom: 8,
  },
  icon: {
    width: 48,
    height: 48,
  },
  boxText: {
    color: '#29486A',
    fontWeight: 'bold',
    fontSize: 13,
    textAlign: 'center',
  },
  buttonContainer: {
    alignItems: 'center',
    marginVertical: 15,
  },
  gradientButton: {
    width: '40%',
    borderRadius: 5,
    overflow: 'hidden',
  },
  gradientButtonContent: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
  },
  buttonText: {
    color: 'white',
    fontSize: 16,
    fontWeight: 'bold',
    marginRight: 5,
  },
  syncModalContainer: {
    flex: 1,
    backgroundColor: 'rgba(0,0,0,0.5)',
    justifyContent: 'center',
    alignItems: 'center',
  },
  syncModalContent: {
    width: '70%',
    backgroundColor: 'white',
    borderRadius: 10,
    padding: 20,
    alignItems: 'center',
  },
  syncModalText: {
    fontSize: 18,
    marginBottom: 10,
    color: '#333',
  },
  syncIcon: {
    width: 30,
    height: 30,
    marginRight: 10,
  },
  syncModalTextadd: {
    fontSize: 14,
    color: '#333',
  },
  syncIcondiv: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
});

export default Team_employment_Home;