import React, { useState } from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Modal,
  Dimensions,
  ScrollView,
} from 'react-native';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import FontAwesome from 'react-native-vector-icons/FontAwesome';
import Feather from 'react-native-vector-icons/Feather';
import AntDesign from 'react-native-vector-icons/AntDesign';
import Entypo from 'react-native-vector-icons/Entypo';

const { width } = Dimensions.get('window');

const INCIDENT_DATA = {
  incidentNumber: 'TD1235',
  inspector: 'fffhfgf',
  vehicle: 'test',
  correctiveAction: 'Abc',
  correctiveActionStatus: 'Not takn',
  date: '10-feb-02:57PM',
};

const ACTIONS = [
  {
    label: 'View Report',
    icon: <FontAwesome name="file-pdf-o" size={20} color="#22628F" />, // PDF icon
    color: '#22628F',
  },
  {
    label: 'Share',
    icon: <Feather name="share-2" size={20} color="#1E88E5" />, // Share icon
    color: '#1E88E5',
  },
  {
    label: 'Create Work Order',
    icon: <Feather name="settings" size={20} color="#00BFAE" />, // Gear icon
    color: '#00BFAE',
  },
  {
    label: 'Corrective Action',
    icon: <MaterialIcons name="offline-bolt" size={20} color="#A259D9" />, // Lightning icon
    color: '#A259D9',
  },
  {
    label: 'Archive Inspection',
    icon: <Feather name="archive" size={20} color="#2262B0" />, // Archive icon
    color: '#2262B0',
  },
  {
    label: 'Delete',
    icon: <AntDesign name="delete" size={20} color="#F9A825" />, // Delete icon
    color: '#F9A825',
  },
  {
    label: 'Risk Assessment',
    icon: <Entypo name="warning" size={20} color="#B71C1C" />, // Warning icon
    color: '#B71C1C',
  },
];

const IncidentReport = () => {
  const [menuVisible, setMenuVisible] = useState(false);

  return (
    <View style={styles.root}>
      {/* Incident Card */}
      <View style={styles.card}>
        <View style={styles.cardHeader}>
          <Text style={styles.incidentNumber}>{INCIDENT_DATA.incidentNumber}</Text>
          <TouchableOpacity style={styles.breakdownButton}>
            <Text style={styles.breakdownButtonText}>Breakdown</Text>
          </TouchableOpacity>
        </View>
        <View style={styles.row}>
          <Text style={styles.label}>Inspector</Text>
          <Text style={styles.value}>{INCIDENT_DATA.inspector}</Text>
        </View>
        <View style={styles.row}>
          <Text style={styles.label}>Vehicle</Text>
          <Text style={styles.value}>{INCIDENT_DATA.vehicle}</Text>
        </View>
        <View style={styles.row}>
          <Text style={styles.label}>Corrective Action</Text>
          <View style={{ flexDirection: 'row', alignItems: 'center' }}>
            <View style={styles.statusPill}>
              <Text style={styles.statusPillText}>{INCIDENT_DATA.correctiveActionStatus}</Text>
            </View>
            <Text style={[styles.value, { marginLeft: 8 }]}>{INCIDENT_DATA.correctiveAction}</Text>
          </View>
        </View>
        <View style={styles.row}>
          <Text style={styles.label}>Date</Text>
          <View style={{ flexDirection: 'row', alignItems: 'center' }}>
            <Text style={styles.value}>{INCIDENT_DATA.date}</Text>
            <TouchableOpacity onPress={() => setMenuVisible(true)} style={{ marginLeft: 8 }}>
              <MaterialIcons name="more-vert" size={22} color="#222" />
            </TouchableOpacity>
          </View>
        </View>
      </View>

      {/* Action Menu */}
      <Modal
        visible={menuVisible}
        transparent
        animationType="fade"
        onRequestClose={() => setMenuVisible(false)}
      >
        <TouchableOpacity
          style={styles.menuOverlay}
          activeOpacity={1}
          onPress={() => setMenuVisible(false)}
        >
          <View style={styles.menuContainer}>
            {ACTIONS.map((action, idx) => (
              <TouchableOpacity key={action.label} style={styles.menuItem}>
                <View style={styles.menuIcon}>{action.icon}</View>
                <Text style={[styles.menuLabel, { color: action.color }]}>{action.label}</Text>
              </TouchableOpacity>
            ))}
          </View>
        </TouchableOpacity>
      </Modal>
    </View>
  );
};

const styles = StyleSheet.create({
  root: {
    flex: 1,
    backgroundColor: '#fff',
    alignItems: 'center',
    justifyContent: 'flex-start',
    paddingTop: width * 0.1,
  },
  card: {
    width: width * 0.95,
    backgroundColor: '#fff',
    borderRadius: 8,
    elevation: 3,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.08,
    shadowRadius: 4,
    padding: width * 0.04,
    marginBottom: 20,
  },
  cardHeader: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    marginBottom: 12,
  },
  incidentNumber: {
    color: '#22628F',
    fontSize: width * 0.05,
    fontWeight: '500',
  },
  breakdownButton: {
    backgroundColor: '#22628F',
    borderRadius: 4,
    paddingHorizontal: 12,
    paddingVertical: 4,
  },
  breakdownButtonText: {
    color: '#fff',
    fontSize: width * 0.032,
    fontWeight: '500',
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingVertical: 8,
    borderBottomWidth: 1,
    borderBottomColor: '#F2F2F2',
  },
  label: {
    color: '#222',
    fontSize: width * 0.038,
    fontWeight: '400',
  },
  value: {
    color: '#222',
    fontSize: width * 0.038,
    fontWeight: '500',
  },
  statusPill: {
    backgroundColor: '#888',
    borderRadius: 4,
    paddingHorizontal: 8,
    paddingVertical: 2,
    marginRight: 2,
  },
  statusPillText: {
    color: '#fff',
    fontSize: width * 0.03,
    fontWeight: '500',
  },
  menuOverlay: {
    flex: 1,
    backgroundColor: 'rgba(0,0,0,0.08)',
    justifyContent: 'flex-start',
    alignItems: 'flex-end',
    paddingTop: width * 0.25,
    paddingRight: width * 0.03,
  },
  menuContainer: {
    width: width * 0.5,
    backgroundColor: '#fff',
    borderRadius: 8,
    elevation: 8,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.15,
    shadowRadius: 6,
    paddingVertical: 6,
  },
  menuItem: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 12,
    paddingHorizontal: 18,
    borderBottomWidth: 1,
    borderBottomColor: '#f0f0f0',
  },
  menuIcon: {
    marginRight: 12,
  },
  menuLabel: {
    fontSize: width * 0.038,
    fontWeight: '500',
  },
});

export default IncidentReport; 