#!/bin/bash

# Sync the entire backend directory to the remote server's /root/node-mongo-api path.

set -euo pipefail

export SSHPASS='5aXBS2f-y/vwM8#'

SOURCE_DIR="$(cd "$(dirname "$0")" && pwd)"
TARGET_HOST="root@168.231.113.219"
TARGET_DIR="/root/node-mongo-api"
SSH_OPTS="-o ConnectTimeout=30 -o ServerAliveInterval=60 -o StrictHostKeyChecking=no"

EXCLUDES=(
  "node_modules"
  ".git"
  ".DS_Store"
  "__MACOSX"
  "*.swp"
  "*.tmp"
)

RSYNC_EXCLUDES=()
for pattern in "${EXCLUDES[@]}"; do
  RSYNC_EXCLUDES+=(--exclude "$pattern")
done

echo "Ensuring remote directory ${TARGET_DIR} exists..."
sshpass -e ssh ${SSH_OPTS} "${TARGET_HOST}" "mkdir -p \"${TARGET_DIR}\""

echo "Uploading backend from ${SOURCE_DIR} to ${TARGET_HOST}:${TARGET_DIR}..."

sshpass -e rsync -av --progress \
  "${RSYNC_EXCLUDES[@]}" \
  -e "ssh ${SSH_OPTS}" \
  "${SOURCE_DIR}/" \
  "${TARGET_HOST}:${TARGET_DIR}/"

echo "Upload complete."

