// Main server that runs all backend services
// Equipment management - GlobalEquipmentJsonData.js (Port 5001)
// Document management - GlobalEDocumentsHandle3.js (Port 5002)
// Admin Users management - GlobalAdminUsersHandle.js (Port 5003)
// DVIR Handler - GlobalDVIRhandler.js (Port 5006)

const { connectDB } = require('./dbConnection');

console.log('\n🚀 Starting Titan Drilling Backend Services...\n');

// Initialize MongoDB connection FIRST before loading any handlers
(async () => {
  try {
    // Connect to MongoDB once
    await connectDB();
    console.log('\n✅ MongoDB connection established!\n');
    
    // Now load all the handlers (they will use the existing connection)
    startAllServices();
    
  } catch (err) {
    console.error('\n❌ Failed to connect to MongoDB:', err.message);
    console.error('⚠️ Exiting application...\n');
    process.exit(1);
  }
})();

function startAllServices() {

// Set environment variables for ports
process.env.EQUIPMENT_PORT = '5001';
process.env.DOCUMENTS_PORT = '5002';
process.env.ADMIN_USERS_PORT = '5003';
process.env.INSPECTION_PORT = '5004';
process.env.JOBCARD_PORT = '5005';
process.env.DVIR_PORT = '5006';
process.env.INCIDENT_REPORT_PORT = '5007';
process.env.DAILY_REPORTS_PORT = '5008';
process.env.REQUEST_MAINTENANCE_PORT = '5009';
process.env.SERVICE_SCHEDULE_PORT = '5010';
process.env.FUEL_LOG_PORT = '5011';
process.env.LOGBOOK_PORT = '5012';
process.env.HRFORM_PORT = '5013';
process.env.HSE_INSPECTION_PORT = '5014';
process.env.NOTICE_BOARD_PORT = '5015';
process.env.PUSH_NOTIFICATION_PORT = '5016';
process.env.NOTIFICATIONS_PORT = '5017';
process.env.USER_NOTIFICATIONS_PORT = '5018';
process.env.INSPECTION_NOTIFICATIONS_PORT = '5019';
process.env.DVIR_NOTIFICATIONS_PORT = '5020';
process.env.INCIDENT_NOTIFICATIONS_PORT = '5021';
process.env.REQUEST_MAINTENANCE_NOTIFICATIONS_PORT = '5022';
process.env.JOBCARD_NOTIFICATIONS_PORT = '5023';
process.env.SERVICE_SCHEDULE_NOTIFICATIONS_PORT = '5024';
process.env.FUEL_LOG_NOTIFICATIONS_PORT = '5025';
process.env.LOGBOOK_NOTIFICATIONS_PORT = '5026';
process.env.HR_APPLICATION_NOTIFICATIONS_PORT = '5027';
process.env.HSE_INSPECTION_NOTIFICATIONS_PORT = '5028';
process.env.HSE_CORRECTIVE_ACTION_PORT = '5032';
process.env.RISK_ASSESSMENT_PORT = '5031';
process.env.WEBPROADMIN_PORT = '5050';





// Start all three servers
console.log('📊 Starting Equipment Server on port 5001...');
require('./GlobalEquipmentJsonData');

console.log('📁 Starting Documents Server on port 5002...');
require('./GlobalEDocumentsHandle3');

console.log('👥 Starting Admin Users Server on port 5003...');
require('./GlobalAdminUsersHandle');

console.log('🔍 Starting Inspection Handler Server on port 5004...');
require('./GlobalInspectionHandler');




console.log('🔧 Starting Job Card Reports Server on port 5005...');
require('./GlobalJobcardReports');

console.log('🔒 Starting DVIR Handler Server on port 5006...');
require('./GlobalDVIRhandler');

console.log('📋 Starting Incident Report Handler Server on port 5007...');
require('./GlobalIncidentReportHandle');

console.log('📅 Starting Daily Reports Handler Server on port 5008...');
require('./GlobalDailyReportsHandle');

console.log('🔧 Starting Request Maintenance Handler Server on port 5009...');
require('./GlobalRequestMaintenanceHandler');

console.log('📅 Starting Service Schedule Handler Server on port 5010...');
require('./GlobalServiceSchdule');

console.log('⛽ Starting Fuel Log Handler Server on port 5011...');
require('./GlobalFuelLogHandle');

console.log('📓 Starting Logbook Handler Server on port 5012...');
require('./GlobalLogbookHandle');

console.log('📋 Starting HR Form Applications Handler Server on port 5013...');
require('./GlobalHRformApplications');

console.log('🏥 Starting HSE Inspection Handler Server on port 5014...');
require('./GlobalHSEInspectionHandler');

console.log('🛠 Starting HSE Corrective Action Server on port 5032...');
require('./HSEcorectiveaction');

console.log('📢 Starting Notice Board Handler Server on port 5015...');
require('./NoticeWelltoall');

console.log('🔔 Starting Push Notification Handler Server on port 5016...');
require('./PushNotificationHandler');

console.log('📬 Starting Notifications Handler Server on port 5017...');
require('./GlobalNotificationsHandle');

console.log('👥 Starting User Creation Notifications Server on port 5018...');
require('./EmailsandPushN/UserCreationNotifications');

console.log('📋 Starting Inspection Notifications Server on port 5019...');
require('./EmailsandPushN/InspectionNotifications');

console.log('🚛 Starting DVIR Notifications Server on port 5020...');
require('./EmailsandPushN/DVIRNotifications');

console.log('🚨 Starting Incident Notifications Server on port 5021...');
require('./EmailsandPushN/IncidentNotifications');

console.log('🔧 Starting Request Maintenance Notifications Server on port 5022...');
require('./EmailsandPushN/RequestMaintenanceNotifications');

console.log('📋 Starting Job Card Notifications Server on port 5023...');
require('./EmailsandPushN/JobCardNotifications');

console.log('📅 Starting Service Schedule Notifications Server on port 5024...');
require('./EmailsandPushN/ServiceScheduleNotifications');

console.log('⛽ Starting Fuel Log Notifications Server on port 5025...');
require('./EmailsandPushN/FuelLogNotifications');

console.log('📔 Starting Logbook Notifications Server on port 5026...');
require('./EmailsandPushN/LogbookNotifications');

console.log('📝 Starting HR Application Notifications Server on port 5027...');
require('./EmailsandPushN/HRApplicationNotifications');

console.log('🏥 Starting HSE Inspection Notifications Server on port 5028...');
require('./EmailsandPushN/HSEInspectionNotifications');

console.log('⚠️ Starting Risk Assessment Server on port 5031...');
require('./GlobalRiskAssessmentHandler');

console.log('🔐 Starting Web Pro Admin Login Server on port 5050...');
require('./ProWebAdmin/webProadminlogin');

console.log('\n✅ All servers initialized!\n');
console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
console.log('📡 Equipment API: https://api.titandrillingzm.com:5001');
console.log('📡 Documents API: https://api.titandrillingzm.com:5002');
console.log('📡 Admin Users API: https://api.titandrillingzm.com:5003');
console.log('📡 Inspection API: https://api.titandrillingzm.com:5004');
console.log('📡 Job Card API: https://api.titandrillingzm.com:5005');
console.log('📡 DVIR Handler API: https://api.titandrillingzm.com:5006');
console.log('📡 Incident Report API: https://api.titandrillingzm.com:5007');
console.log('📡 Daily Reports API: https://api.titandrillingzm.com:5008');
console.log('📡 Request Maintenance API: https://api.titandrillingzm.com:5009');
console.log('📡 Service Schedule API: https://api.titandrillingzm.com:5010');
console.log('📡 Fuel Log API: https://api.titandrillingzm.com:5011');
console.log('📡 Logbook API: https://api.titandrillingzm.com:5012');
console.log('📡 HR Form Applications API: https://api.titandrillingzm.com:5013');
console.log('📡 HSE Inspection API: https://api.titandrillingzm.com:5014');
console.log('📡 Notice Board API: https://api.titandrillingzm.com:5015');
console.log('📡 Push Notification API: https://api.titandrillingzm.com:5016');
console.log('📡 Notifications API: https://api.titandrillingzm.com:5017');
console.log('📡 User Creation Notifications API: https://api.titandrillingzm.com:5018');
console.log('📡 Inspection Notifications API: https://api.titandrillingzm.com:5019');
console.log('📡 DVIR Notifications API: https://api.titandrillingzm.com:5020');
console.log('📡 Incident Notifications API: https://api.titandrillingzm.com:5021');
console.log('📡 Request Maintenance Notifications API: https://api.titandrillingzm.com:5022');
console.log('📡 Job Card Notifications API: https://api.titandrillingzm.com:5023');
console.log('📡 Service Schedule Notifications API: https://api.titandrillingzm.com:5024');
console.log('📡 Fuel Log Notifications API: https://api.titandrillingzm.com:5025');
console.log('📡 Logbook Notifications API: https://api.titandrillingzm.com:5026');
console.log('📡 HR Application Notifications API: https://api.titandrillingzm.com:5027');
console.log('📡 HSE Inspection Notifications API: https://api.titandrillingzm.com:5028');
console.log('📡 Web Pro Admin Login API: https://api.titandrillingzm.com:5050');
console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n');

} // End of startAllServices()
