# Web Pro Admin MongoDB Authentication

## Overview
This system implements MongoDB-based authentication for the Web Pro Admin panel, replacing the previous phpMyAdmin/MySQL authentication.

## Configuration

### MongoDB Connection
- **Database**: `titan_drilling`
- **Collection**: `WebProadmin`
- **Connection String**: `mongodb://titandrillingadminuser:mrdThsSnATwD231hbOPmnhj@api.titandrillingzm.com:27017/titan_drilling?authSource=admin`

### API Endpoint
- **Port**: 5050
- **Base URL**: `https://api.titandrillingzm.com:5050`

## Initial Admin User

The system automatically creates an initial admin user on first startup:

```json
{
  "email": "admin@titandrillingzm.com",
  "password": "admin@titandrillingzm.comA1",
  "role": "WebProAdmin",
  "name": "Amit.coder"
}
```

**⚠️ IMPORTANT**: Change this password after first login!

## API Endpoints

### 1. Login
- **URL**: `POST /api/webproadmin/login`
- **Request**:
```json
{
  "email": "admin@titandrillingzm.com",
  "password": "admin@titandrillingzm.comA1"
}
```
- **Response**:
```json
{
  "success": true,
  "message": "Login successful",
  "user": {
    "uid": "user_1761833101603_9zsp1be58",
    "name": "Amit.coder",
    "email": "admin@titandrillingzm.com",
    "role": "WebProAdmin",
    "countries": ["DRC", "Zambia"],
    "projects": ["Lubumbashi", "Musompo", "IME", "Kamoa", ...],
    "modules": [...]
  }
}
```

### 2. Logout
- **URL**: `POST /api/webproadmin/logout`
- **Request**:
```json
{
  "uid": "user_1761833101603_9zsp1be58"
}
```

### 3. Get User Profile
- **URL**: `GET /api/webproadmin/profile/:uid`
- **Response**: User object without sensitive data

### 4. Get All Web Pro Admins
- **URL**: `GET /api/webproadmin/all`
- **Response**: Array of all admin users

### 5. Create New Web Pro Admin
- **URL**: `POST /api/webproadmin/create`
- **Request**:
```json
{
  "name": "New Admin",
  "email": "newadmin@example.com",
  "password": "SecurePassword123!",
  "role": "WebProAdmin",
  "countries": ["Zambia"],
  "projects": ["Kansanshi"],
  ...
}
```

## Laravel Integration

### Environment Variables (.envlive)
```env
# MongoDB API Configuration
MONGODB_API_BASE_URL=https://api.titandrillingzm.com:5050
MONGODB_WEBPROADMIN_LOGIN_URL=https://api.titandrillingzm.com:5050/api/webproadmin/login
MONGODB_WEBPROADMIN_LOGOUT_URL=https://api.titandrillingzm.com:5050/api/webproadmin/logout
MONGODB_WEBPROADMIN_PROFILE_URL=https://api.titandrillingzm.com:5050/api/webproadmin/profile
```

### How It Works

1. **User Login at** `http://127.0.0.1:8000/admin/login`:
   - User enters email and password
   - Laravel sends credentials to MongoDB API (port 5050)
   - MongoDB API validates against `WebProadmin` collection
   - If valid, MongoDB user data is returned
   - Laravel creates/updates local user for session management
   - User data stored in session with `mongo_user_data` and `mongo_user_uid`

2. **Session Management**:
   - Local User model used for Laravel session/auth
   - MongoDB user data synced to local database
   - Full user permissions/modules available in session

3. **Logout**:
   - Laravel notifies MongoDB API to update login status
   - Local session invalidated
   - User redirected to login page

## Deployment

### Upload to Server
```bash
cd /Applications/XAMPP/xamppfiles/htdocs/onlytitanweb/titan_drilling-laraval/Appmongosetup/backend
bash upload-to-server.sh
```

### Start Service Locally (for testing)
```bash
cd /Applications/XAMPP/xamppfiles/htdocs/onlytitanweb/titan_drilling-laraval/Appmongosetup/backend
node ProWebAdmin/webProadminlogin.js
```

### Check Service Status
```bash
curl https://api.titandrillingzm.com:5050/health
```

Expected response:
```json
{
  "status": "OK",
  "service": "Web Pro Admin Login",
  "port": 5050,
  "timestamp": "2025-10-31T..."
}
```

## Security Features

1. **Password Hashing**: bcrypt with 10 salt rounds
2. **Session Management**: Laravel session security
3. **Sensitive Data Removal**: Passwords removed from API responses
4. **Login Tracking**: Last login timestamp updated
5. **Error Logging**: All authentication attempts logged

## Testing

### Test MongoDB API
```bash
curl -X POST https://api.titandrillingzm.com:5050/api/webproadmin/login \
  -H "Content-Type: application/json" \
  -d '{
    "email": "admin@titandrillingzm.com",
    "password": "admin@titandrillingzm.comA1"
  }'
```

### Test Laravel Login
1. Visit: `http://127.0.0.1:8000/admin/login`
2. Enter credentials:
   - Email: `admin@titandrillingzm.com`
   - Password: `admin@titandrillingzm.comA1`
3. Should redirect to dashboard

## Troubleshooting

### Login Fails
1. Check MongoDB API is running: `curl https://api.titandrillingzm.com:5050/health`
2. Check Laravel logs: `storage/logs/laravel.log`
3. Verify MongoDB connection in API
4. Check .envlive file has correct MongoDB API URL

### Service Not Starting
1. Check port 5050 is available: `lsof -i :5050`
2. Check MongoDB connection string
3. Check server.js includes ProWebAdmin service
4. Check PM2 logs: `pm2 logs titan-drilling-api`

## Files Modified/Created

### New Files
- `Appmongosetup/backend/ProWebAdmin/webProadminlogin.js` - MongoDB API service
- `Appmongosetup/backend/ProWebAdmin/README_WEBPROADMIN_LOGIN.md` - This file

### Modified Files
- `Appmongosetup/backend/server.js` - Added port 5050 and service loader
- `Appmongosetup/backend/upload-to-server.sh` - Added ProWebAdmin folder upload
- `.envlive` - Added MongoDB API configuration
- `app/Http/Controllers/AuthController.php` - MongoDB authentication integration

## Support

For issues or questions:
- Check logs in `storage/logs/laravel.log`
- Monitor MongoDB API: `https://api.titandrillingzm.com:5050/health`
- Review PM2 status: `pm2 status`

